﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using Microsoft.Xna.Framework;
using GE.Physics;

namespace GE.World.Entities
{
    /// <summary>
    /// Represent an entity which hurts the player when touched
    /// </summary>
    class SpikeEntity : WorldEntity
    {

        /// <summary>
        /// Physic shape
        /// </summary>
        StaticShapeRectangle _shape;

        /// <summary>
        /// Constructor
        /// </summary>
        public SpikeEntity() : base()
        {
        }

        /// <summary>
        /// Activator
        /// </summary>
        /// <param name="rec"></param>
        public void activate(Rectangle rec)
        {
            
            _bActive = true;
            _shape = Physics.Physics.Instance.createStaticRectangle(rec.Width, rec.Height, Vector2.Zero, new Vector2(rec.X, rec.Y), 0, this);
            _shape._iGroup = (int)ePhysicGroup.ePhysicSpike;
           // _shape._v2position = new Vector2(rec.X, rec.Y);
            _shape._bCollisionEnable = true;
        }

        /// <summary>
        /// Update
        /// </summary>
        public override void update()
        {
            CollisionResult res = Physics.Physics.Instance.checkFirstRegisteredCollisionEx(_shape, (int)ePhysicGroup.ePhysicPlayer);
            if (res == null) return;

            //res.Entity.hurt(World.Instance.PlayerEntity.TotalHealthPoint);
            res.Entity.die();
        }

    }
}
